<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-11-18 12:21
 */
interface TaskorderproductsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Taskorderproducts 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param taskorderproduct primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Taskorderproducts taskorderproduct
 	 */
	public function insert($taskorderproduct);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Taskorderproducts taskorderproduct
 	 */
	public function update($taskorderproduct);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTaskorderid($value);

	public function queryByProductid($value);

	public function queryByUnitid($value);

	public function queryByQuantity($value);


	public function deleteByTaskorderid($value);

	public function deleteByProductid($value);

	public function deleteByUnitid($value);

	public function deleteByQuantity($value);


}
?>